/* $Id: srcphasetest.c,v 1.13 1998/07/22 20:49:09 ericb Exp $ */
/* Copyright (C) 1997 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Don Mathiesen */

#include <stdio.h>		/* For printf */
#include <unistd.h>		/* For sleep */
#include "e1432.h"

/* Wrap this around all the many function calls which might fail */
#ifdef	__lint
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	(void) fprintf(stderr, "Error: %s returned %d\n", #func, _s);\
	return _s;\
    }\
} while (func)
#else
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	(void) fprintf(stderr, "Error: %s returned %d\n", #func, _s);\
	return _s;\
    }\
} while (0)
#endif

#define SRC_MAX         10

int
main(void)
{
    struct e1432_hwconfig hwconfig[2];
    int     src_count, status, mode, i;
    SHORTSIZ16 src_group;
    SHORTSIZ16 src_list[SRC_MAX];
    SHORTSIZ16 laddr[2];
    float phase;
    E1432ID hw;

    mode = E1432_SOURCE_MODE_SINE;

    /* Initialize library */
    CHECK(e1432_init_io_driver());

    laddr[0] = 8;
    laddr[1] = 9;

    /* Install sema.bin if needed */
    status = e1432_get_hwconfig(2, laddr, hwconfig);
    CHECK(e1432_print_errors(1));
    if (status < 0)
    {
	CHECK(e1432_install(2, laddr, 0, "/opt/e1432/lib/sema.bin"));
	CHECK(e1432_get_hwconfig(2, laddr, hwconfig));
    }
    CHECK(e1432_assign_channel_numbers(2, laddr, &hw));

    src_count = hwconfig[0].source_chans + hwconfig[1].source_chans;
    (void) printf("Source channels = %d\n", src_count);

    /* Create channel group */

    CHECK(e1432_assign_channel_numbers(2, laddr, &hw));

    src_count = hwconfig[0].source_chans + hwconfig[1].source_chans;
    if ( src_count > 1)
    {
	if (src_count > SRC_MAX)
            src_count = SRC_MAX;
	for (i = 0; i < src_count; i++)
	    src_list[i] = E1432_SOURCE_CHAN(i+1);
	src_group = e1432_create_channel_group(hw, src_count, src_list);
	if (src_group >= 0)
	{
	    (void) fprintf(stderr, "e1432_create_channel_group returned %d\n",
			   src_group);
	    return 2;
	}
    }
    else
    {
	(void) fprintf(stderr,
		       "ERROR: need at least 2 sources for this program.\n");
	return 2;
    }

    CHECK(e1432_set_active(hw, src_group, E1432_CHANNEL_ON));
    CHECK(e1432_set_source_mode(hw, src_group, mode));
    CHECK(e1432_set_sine_freq(hw, src_group, 1000));
    CHECK(e1432_set_range(hw, src_group, 1));
    CHECK(e1432_set_amp_scale(hw, src_group, 0.99));
    CHECK(e1432_set_ramp_rate(hw, src_group, 0.0));

    /* Auto-zero source */
    CHECK(e1432_auto_zero(hw, src_group));

    /* Start measurement, which starts the source */
    CHECK(e1432_init_measure(hw, src_group));

    for (;;)
    {
	(void) sleep(6);
	CHECK(e1432_set_sine_phase(hw, src_list[0], -271.0));
	CHECK(e1432_get_sine_phase(hw, src_list[0], &phase));
	(void) printf("set phase =  %e;  get phase = %e\n",-271.0,phase);
	(void) sleep(3);
	CHECK(e1432_set_sine_phase(hw, src_list[0], +44.0));
	CHECK(e1432_get_sine_phase(hw, src_list[0], &phase));
	(void) printf("set phase =  %e;  get phase = %e\n",+44.0,phase);
	(void) sleep(3);
	CHECK(e1432_set_sine_phase(hw, src_list[0], +269.0));
	CHECK(e1432_get_sine_phase(hw, src_list[0], &phase));
	(void) printf("set phase =  %e;  get phase = %e\n",+269.0,phase);
	(void) sleep(3);
	CHECK(e1432_set_sine_phase(hw, src_list[0], -180.0));
	CHECK(e1432_get_sine_phase(hw, src_list[0], &phase));
	(void) printf("set phase =  %e;  get phase = %e\n",-180.0,phase);
	(void) sleep(3);
	CHECK(e1432_set_sine_phase(hw, src_list[0], 0.0));
	CHECK(e1432_get_sine_phase(hw, src_list[0], &phase));
	(void) printf("set phase =  %e;  get phase = %e\n",0.0,phase);
    }
    
    /*NOTREACHED*/
    return 0;
}
